//=============================================================================
// Block.
//=============================================================================
class Block extends DeusExWeapon abstract;

var bool bGridSnap;
var float GridSize;

var class<Decoration> BlockClass;
var int BlockHP;
var bool bNeedBranch;

function EraseMuzzleFlashTexture()
{
}

function int OtherEnd(int i)
{
 if (i == 0) return 1;
 if (i == 1) return 0;

 if (i == 2) return 3;
 if (i == 3) return 2;

 if (i == 4) return 5;
 if (i == 5) return 4;
}

function GiveTo(Pawn A)
{
 Super.GiveTo(A);
 
 FixInvGrouping();
}

function Actor PollLocation(Vector V)
{
 local Actor A;
 
 forEach RadiusActors(class'Actor', A, 256, V)
 {
  if (A != None && A.IsA('BlockDeployed'))
  {
   if (A.Location.X == V.X && A.Location.Y == V.Y && A.Location.Z == V.Z)
   {
    return A;
   }
  }
 }
 
 return None;
}


function int GetSideNum(Vector Norm)
{
 local float XVal, YVal, ZVal;
 
 ZVal = ABS(Norm.Z);
 YVal = ABS(Norm.Y);
 XVal = ABS(Norm.X);
  
 if (XVal >= YVal && XVal >= ZVal)
 {
  if (Norm.X >= 0) return 3;
  if (Norm.X < 0) return 2;
 }
 if (YVal > XVal && YVal >= ZVal)
 {
  if (Norm.Y >= 0) return 5;
  if (Norm.Y < 0) return 4;
 }
 if (ZVal > XVal && ZVal > YVal)
 {
  if (Norm.Z >= 0) return 1;
  if (Norm.Z < 0) return 0;
 }
 
 return -1;
}

function Vector GetNormal(int Side)
{
 if (Side == 0) return vect(0,0,2) * GridSize;
 if (Side == 1) return vect(0,0,2) * GridSize * -1;
 if (Side == 2) return vect(2,0,0) * GridSize;
 if (Side == 3) return vect(2,0,0) * GridSize * -1;
 if (Side == 4) return vect(0,2,0) * GridSize;
 if (Side == 5) return vect(0,2,0) * GridSize * -1;
 
 return vect(0,0,0);
}

//fix the stuck up glitches around acquiring the same inv group twice.
function FixInvGrouping()
{
 local Byte B;
 local Weapon W;
 local int i, k;
 
  forEach AllActors(class'Weapon', W)
  {
   if (W != Self)
    k++;
  }
 
 do
 {
  forEach AllActors(class'Weapon', W)
  {
   
   if (B == W.InventoryGroup && W != Self || (IsTakenByDefault(B)))
   {
    B ++;
    i = 0;
    break;
   }
   
   if (W != Self)
   {
    i++;
   }
   
  }
 }
 until (i == k)
 
 InventoryGroup = B;
 //Default.InventoryGroup = B;
}


function Bool IsTakenByDefault(int i)
{
 if (i == class'WeaponAssaultGun'.Default.InventoryGroup) return True;
 if (i == class'WeaponAssaultShotgun'.Default.InventoryGroup) return True;
 if (i == class'WeaponBaton'.Default.InventoryGroup) return True;
 if (i == class'WeaponCombatKnife'.Default.InventoryGroup) return True;
 if (i == class'WeaponCrowbar'.Default.InventoryGroup) return True;
 if (i == class'WeaponEMPGrenade'.Default.InventoryGroup) return True;
 if (i == class'WeaponFlamethrower'.Default.InventoryGroup) return True;
 if (i == class'WeaponGasGrenade'.Default.InventoryGroup) return True;
 if (i == class'WeaponGEPGun'.Default.InventoryGroup) return True;
 if (i == class'WeaponHideAGun'.Default.InventoryGroup) return True;
 if (i == class'WeaponLAM'.Default.InventoryGroup) return True;
 if (i == class'WeaponLAW'.Default.InventoryGroup) return True;
 if (i == class'WeaponMiniCrossbow'.Default.InventoryGroup) return True;
 if (i == class'WeaponNanoSword'.Default.InventoryGroup) return True;
 if (i == class'WeaponNanoVirusGrenade'.Default.InventoryGroup) return True;
 if (i == class'WeaponPepperGun'.Default.InventoryGroup) return True;
 if (i == class'WeaponPistol'.Default.InventoryGroup) return True;
 if (i == class'WeaponPlasmaRifle'.Default.InventoryGroup) return True;
 if (i == class'WeaponProd'.Default.InventoryGroup) return True;
 if (i == class'WeaponRifle'.Default.InventoryGroup) return True;
 if (i == class'WeaponSawedOffShotgun'.Default.InventoryGroup) return True;
 if (i == class'WeaponShuriken'.Default.InventoryGroup) return True;
 if (i == class'WeaponStealthPistol'.Default.InventoryGroup) return True;
 if (i == class'WeaponSword'.Default.InventoryGroup) return True;
 
 return False;
}

function LaserToggle()
{
 if (!bNeedBranch) AttemptBlockPlace();
 if (bNeedBranch) AttemptDependantBlockPlace();
}

function ScopeToggle()
{
 if (!bNeedBranch) AttemptBlockPlace();
 if (bNeedBranch) AttemptDependantBlockPlace();
}

function AltFire(float f)
{
 if (!bNeedBranch) AttemptBlockPlace();
 if (bNeedBranch) AttemptDependantBlockPlace();
}

//RIP tantalus, dead from ripped code syndrome.
function AttemptBlockPlace()
{
 local Vector Pos, line, HitLoc, HitNorm, TempNorm;
 local float Xdif, Ydif, Zdif;
 local Actor A;
 
 Pos = Owner.Location;
 Pos.Z += DeusExPlayer(Owner).BaseEyeHeight;
 
 Line = Vector(Pawn(Owner).ViewRotation) * 4000;
 
 A = Trace(HitLoc, HitNorm, Pos + Line, Pos, True);
 
 if (A != None && A != Level && !A.IsA('Mover'))
 {
  XDif = ABS(HitNorm.X);
  YDif = ABS(HitNorm.Y);
  ZDif = ABS(HitNorm.Z);
  
  if (XDif >= YDif && XDif >= ZDif)
  {
   HitLoc = HitLoc + ( (HitNorm * vect(1,0,0)) * 1 * A.CollisionRadius / 8);
   
   if (!A.IsA('BlockDeployed'))
   {
    HitLoc.Y = A.Location.Y;
    HitLoc.Z = A.Location.Z;
   }
  }
  if (YDif > XDif && YDif >= ZDif)
  {
   HitLoc = HitLoc + ( (HitNorm * vect(0,1,0)) * 1 * A.CollisionRadius / 8);
   
   if (!A.IsA('BlockDeployed'))
   {
    HitLoc.X = A.Location.X;
    HitLoc.Z = A.Location.Z;
   }
  }
  if (ZDif > XDif && ZDif > YDif)
  {
   HitLoc = HitLoc + ( (HitNorm * vect(0,0,1)) * 1 * A.CollisionHeight / 16);
   
   if (!A.IsA('BlockDeployed'))
   {
    HitLoc.X = A.Location.X;
    HitLoc.Y = A.Location.Y;
   }
  }
 }
 
 PlaceBlock(HitLoc, HitNorm);
}

function AttemptDependantBlockPlace()
{
 local Vector Pos, line, HitLoc, HitNorm, TempNorm;
 local float Xdif, Ydif, Zdif;
 local Actor A;
 
 Pos = Owner.Location;
 Pos.Z += DeusExPlayer(Owner).BaseEyeHeight;
 
 Line = Vector(Pawn(Owner).ViewRotation) * 4000;
 
 A = Trace(HitLoc, HitNorm, Pos + Line, Pos, True);
 
 if (A != None && A != Level && !A.IsA('Mover'))
 {
  XDif = ABS(HitNorm.X);
  YDif = ABS(HitNorm.Y);
  ZDif = ABS(HitNorm.Z);
  
  if (XDif >= YDif && XDif >= ZDif)
  {
   HitLoc = HitLoc + ( (HitNorm * vect(1,0,0)) * 1 * A.CollisionRadius / 8);
   
   if (!A.IsA('BlockDeployed'))
   {
    HitLoc.Y = A.Location.Y;
    HitLoc.Z = A.Location.Z;
   }
  }
  if (YDif > XDif && YDif >= ZDif)
  {
   HitLoc = HitLoc + ( (HitNorm * vect(0,1,0)) * 1 * A.CollisionRadius / 8);
   
   if (!A.IsA('BlockDeployed'))
   {
    HitLoc.X = A.Location.X;
    HitLoc.Z = A.Location.Z;
   }
  }
  if (ZDif > XDif && ZDif > YDif)
  {
   HitLoc = HitLoc + ( (HitNorm * vect(0,0,1)) * 1 * A.CollisionHeight / 16);
   
   if (!A.IsA('BlockDeployed'))
   {
    HitLoc.X = A.Location.X;
    HitLoc.Y = A.Location.Y;
   }
  }
 }
 
 if (A.IsA('BlockDeployed'))
 {
  if (BlockDeployed(A).bCanBranch) PlaceBlock(HitLoc, HitNorm);
 }
}


function PlaceBlock(Vector Location, Vector HitNorm)
{
 local Vector PlaceLoc;
 local Decoration D;


 local float Xdif, Ydif, Zdif;

 
 PlaceLoc = Location;
 
 PlaceLoc.X = RoundUnits(PlaceLoc.X);
 PlaceLoc.Y = RoundUnits(PlaceLoc.Y);
 PlaceLoc.Z = RoundUnits(PlaceLoc.Z);
 
 if (PollLocation(PlaceLoc) == None) D = Spawn(BlockClass,Owner,,PlaceLoc,Rot(0,0,0));
 
 if (D == None && PollLocation(PlaceLoc) == None)
 {
  PlaceLoc = PlaceLoc + (HitNorm * GridSize);
  
  PlaceLoc.X = RoundUnits(PlaceLoc.X);
  PlaceLoc.Y = RoundUnits(PlaceLoc.Y);
  PlaceLoc.Z = RoundUnits(PlaceLoc.Z);
  
  if (PollLocation(PlaceLoc) == None) D = Spawn(BlockClass,Owner,,PlaceLoc,Rot(0,0,0));
 }
 
 if (D != None)
 {
  BlockDeployed(D).DependantDirection = GetSideNum(HitNorm);
  BlockDeployed(D).HitPoints = BlockHP;
  //BlockDeployed(D).Contents = Self.Class;
  BlockDeployed(D).ApplyBlockName(ItemName);
  BlockDeployed(D).ApplyBlockSize(GridSize / 2);

  D.Skin = Skin;
  D.Multiskins[0] = Default.Multiskins[0];
  D.Multiskins[1] = Multiskins[1];
  D.Multiskins[2] = Multiskins[2];
  D.Multiskins[3] = Multiskins[3];
  D.Multiskins[4] = Multiskins[4];
  D.Multiskins[5] = Multiskins[5];
 }
}

function int RoundUnits(int i)
{
 local string S;
 local int Length, Singles, Offset, bRoundUp;
 local bool bNegative;
 
 bNegative = (i < 0);
 
 Singles = ABS(i);

 if (Singles > GridSize)
 {
  do
  {
   Singles -= GridSize;
  }
  until (Singles < GridSize)
 }
 
 if (float(Singles) >= GridSize / 2) bRoundUp = 1; 
 
 if (!bNegative) i = i - Singles + (GridSize * bRoundUp);
 if (bNegative) i = i + Singles - (GridSize * bRoundUp);
 
 return i;
}

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 Multiskins[0] = None;
}

defaultproperties
{
     LowAmmoWaterMark=-1
     FireSound=None
     GoverningSkill=None
     EnviroEffective=ENVEFF_All
     Concealability=CONC_All
     ShotTime=0.500000
     reloadTime=0.100000
     HitDamage=0
     maxRange=0
     bHandToHand=True
     AccurateRange=0
     BaseAccuracy=0.000000
     bHasMuzzleFlash=False
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     PickupAmmoCount=0
     ProjectileClass=None
     shakemag=0.000000
     SelectSound=None
     InventoryGroup=240
     ItemName="EXSAMPLE BLOCK"
     PlayerViewMesh=LodMesh'DeusExDeco.CrateUnbreakableSmall'
     PickupViewMesh=LodMesh'DeusExDeco.CrateUnbreakableSmall'
     ThirdPersonMesh=LodMesh'DeusExDeco.CrateUnbreakableSmall'
     Icon=Texture'DeusExUI.Icons.BeltIconLAM'
     largeIcon=Texture'DeusExUI.Icons.LargeIconLAM'
     largeIconWidth=35
     largeIconHeight=45
     Description="HOLY FLYING TIT-FUCK. ITS A BLOCK."
     beltDescription="BLOCKCOCK"
     Mesh=LodMesh'DeusExItems.LAMPickup'
     CollisionRadius=2.500000
     CollisionHeight=5.000000
     Mass=5.000000
     Buoyancy=5.000000
     
     bGridSnap=True
     GridSize=32

     bNoSmooth=True
     PlayerViewOffset=(X=30.000000,Y=-12.000000,Z=-12.000000)
     PlayerViewScale=0.155000
     PickupViewScale=0.155000
     ThirdPersonScale=0.155000
     BlockHP=100
}
